-- FUNCTION: public.ufd_est_prod_tbl_desc_leve_pague(integer, integer, integer, integer)

-- DROP FUNCTION public.ufd_est_prod_tbl_desc_leve_pague(integer, integer, integer, integer);

CREATE OR REPLACE FUNCTION public.ufd_est_prod_tbl_desc_leve_pague(
	integer,
	integer,
	integer,
	integer,
	integer)
    RETURNS SETOF rs_tab_desc_qtde 
    LANGUAGE 'plpgsql'

    COST 100
    VOLATILE 
    ROWS 1000
AS $BODY$

-- versão 23/09/2020


 --<<INICIO DO CORPO DA FUNCAO
-- Function: select * from ufd_est_prod_tbl_desc_leve_pague(1, 4, 3, 10)
--DECLARA AS VARIAVEIS USADAS NA FUNCAO
DECLARE
---------------------------------------------------------
----DECLARA AS VARIAVEIS QUE ESTAO NO CABECALHO DA FUNCAO
---------------------------------------------------------
int_cd_emp              ALIAS FOR $1;
int_cd_filial           ALIAS FOR $2; 
int_cd_prod             ALIAS FOR $3;
int_qtde             	ALIAS FOR $4;
int_cd_forma_pgto       ALIAS FOR $5;
---------------------------------------------------------
---FIM
---------------------------------------------------------
var_trabalhacomdescontoformadepagamento 	integer;


returnRec rs_tab_desc_qtde; --RECEBERA OS DADOS DE RETORNO DA FUNCAO
BEGIN --INICIO DOS BLOCOS DA FUNCAO
	-------------------------------------------------------------------------------------------------------------------------------
	--DECLARANDO TABELA TEMPORARIA DE RETORNO
	-------------------------------------------------------------------------------------------------------------------------------
	BEGIN
		CREATE TEMPORARY TABLE temp_rs_tab_desc_leve_page
		(	
			cd_tbl_desc_qtde 	integer,
			tp_desc 			integer,
			qtde_pag	 		integer,
			tp_nivel			integer,
			agregacao			integer,
			dt_ini              timestamp without time zone
		);
		EXCEPTION WHEN OTHERS THEN
		TRUNCATE TABLE temp_rs_tab_desc_leve_page; -- TRUNCA A TABELA SE ELA JA EXISTIR NA CORRENTE SESSAO.
	END;
	-------------------------------------------------------------------------------------------------------------------------------
	--DECLARANDO TABELA QUE RECEBERA AS TBLS VIGENTES
	-------------------------------------------------------------------------------------------------------------------------------
	BEGIN
		CREATE TEMPORARY TABLE rs_tab_qtde_ativa
		(	
			cd_emp 				integer,    
			cd_tbl_desc_qtde	integer,    
			tp_desc 			integer
		);
		EXCEPTION WHEN OTHERS THEN
		TRUNCATE TABLE rs_tab_qtde_ativa; -- TRUNCA A TABELA SE ELA JA EXISTIR NA CORRENTE SESSAO.
	END;
	-------------------------------------------------------------------------------------------------------------------------------
	--DECLARANDO TABELA DE ARVORE MERCADOLOGICA DO PRODUTO
	-------------------------------------------------------------------------------------------------------------------------------
	BEGIN
		CREATE TEMPORARY TABLE rs_est_prod_arv_merc
		(
			cd_emp					integer,
			cd_prod					integer,
			cd_arv_merc_categ		integer,
			cd_arv_merc_linha		integer,
			cd_mc					integer,
			cd_arv_merc_familia		integer,								
			cd_fabric				integer
		);--fim rs_est_prod_arv_merc
		EXCEPTION WHEN OTHERS THEN
		TRUNCATE TABLE rs_est_prod_arv_merc; -- TRUNCA A TABELA SE ELA JA EXISTIR NA CORRENTE SESSAO.
	END;
	-------------------------------------------------------------------------------------------------------------------------------	
	---------------------------------------------------FIM DA CRIACAO DAS TBLS TEMPORARIAS-----------------------------------------
	-------------------------------------------------------------------------------------------------------------------------------
	-------------------------------------------------------------------------------------------------------------------------------
	--BUSCANDO ARVORE MERC. DO PRODUTO
	-------------------------------------------------------------------------------------------------------------------------------	
	INSERT INTO rs_est_prod_arv_merc		
		SELECT 
			arv.cd_emp					,
			arv.cd_prod					,
			arv.cd_arv_merc_categ		,
			arv.cd_arv_merc_linha		,
			arv.cd_mc					,
			arv.cd_arv_merc_familia		,												
			p.cd_fabric 
		FROM 	est_prod_est_arv_mercadologica arv INNER JOIN est_prod p ON
				arv.cd_emp		= p.cd_emp
				AND arv.cd_prod = p.cd_prod
		WHERE   	arv.cd_emp = int_cd_emp
			AND 	arv.cd_prod = int_cd_prod;
			
			
	var_trabalhacomdescontoformadepagamento = coalesce((select coalesce(valor,'0')::integer from prc_filial_config where cd_chave = 'USA_DESCONTO_PGTO' and cd_filial = int_cd_filial), 0);			
			
	IF EXISTS (SELECT 1 FROM rs_est_prod_arv_merc) THEN
		-------------------------------------------------------------------    
		--TABELAS DE DESC. QUANTIDADE    
		-------------------------------------------------------------------    
		INSERT INTO rs_tab_qtde_ativa    
				SELECT  a.cd_emp,    
						a.cd_tbl_desc_qtde,
						a.cd_tp_desconto    
				FROM est_prod_tbl_desc_qtde a INNER JOIN
				     est_prod_tbl_desc_qtde_prc_filial fil ON    
					    a.cd_emp = fil.cd_emp AND    
					    a.cd_tbl_desc_qtde = fil.cd_tbl_desc_qtde 
				WHERE  int_cd_emp = a.cd_emp AND        
					   int_cd_filial = fil.cd_filial AND
					   CURRENT_DATE BETWEEN date(a.dt_ini) AND date(a.dt_fim) AND
					   a.sts_tbl_desc = 1 AND    
					   a.cd_tp_desconto = 24 AND               
					   a.qtde_leve <= int_qtde;
					   
					   
					   
		if var_trabalhacomdescontoformadepagamento = 1 then  
			 
	
			delete from rs_tab_qtde_ativa a 
			 where not exists (select b.cd_emp
			      				 from est_prod_tbl_desc_qtde_forma_pgto b  
				    			where b.cd_emp             = a.cd_emp
				    			  and b.cd_tbl_desc_qtde   = a.cd_tbl_desc_qtde   
				    			  and b.cd_frm_pgto      = int_cd_forma_pgto  
				    			    ) ;
	
		end if ; 					   
					   
					   
					   
		IF EXISTS (SELECT 1 FROM rs_tab_qtde_ativa) THEN
			-------------------------------------------------------------------------------------------------------------------------------    
			--CONSULTANDO AS TBLS DE DESCONTO PARA VERIFICAR SE HA ALGUM DESCONTO NO NIVEL 1 - PRODUTOS    
			-------------------------------------------------------------------------------------------------------------------------------    
			 INSERT INTO temp_rs_tab_desc_leve_page     
				SELECT    
						a.cd_tbl_desc_qtde AS cd_tbl_desc_qtde,    
						a.cd_tp_desconto AS tp_desc,    
						(abs(int_qtde / a.qtde_leve) * a.qtde_pague) + (int_qtde - (abs(int_qtde / a.qtde_leve) * a.qtde_leve)) as qtde_pg, --CALCULA A QUANTIDADE DE PROTUDOS QUE SERAO PAGOS
						1 AS tp_nivel,
						agregacao,
						a.dt_ini
				FROM est_prod_tbl_desc_qtde a    
						INNER JOIN est_prod_tbl_desc_qtde_est_prod b ON    
							a.cd_emp = b.cd_emp AND    
							a.cd_tbl_desc_qtde = b.cd_tbl_desc_qtde    
						INNER JOIN est_prod_tbl_desc_qtde_prc_filial fil ON    
							b.cd_emp = fil.cd_emp AND    
							b.cd_tbl_desc_qtde = fil.cd_tbl_desc_qtde    
						INNER JOIN rs_tab_qtde_ativa atv ON    
							b.cd_emp = atv.cd_emp AND    
							b.cd_tbl_desc_qtde = atv.cd_tbl_desc_qtde     
						INNER JOIN rs_est_prod_arv_merc arv ON    
							b.cd_emp = arv.cd_emp AND    
							b.cd_prod = arv.cd_prod           
				WHERE     
					fil.cd_filial = int_cd_filial;
			-------------------------------------------------------------------------------------------------------------------------------    
			--CONSULTANDO AS TBLS DE DESCONTO PARA VERIFICAR SE HA ALGUM DESCONTO NO NIVEL 2 - FAMILIAS    
			-------------------------------------------------------------------------------------------------------------------------------    
			INSERT INTO temp_rs_tab_desc_leve_page     
				SELECT   
						a.cd_tbl_desc_qtde AS cd_tbl_desc_qtde,    
						a.cd_tp_desconto AS tp_desc,    
						(abs(int_qtde / a.qtde_leve) * a.qtde_pague) + (int_qtde - (abs(int_qtde / a.qtde_leve) * a.qtde_leve)) as qtde_pg,        
						2 AS tp_nivel,
						agregacao,
						a.dt_ini    
				FROM est_prod_tbl_desc_qtde a    
						INNER JOIN est_prod_tbl_desc_qtde_est_arv_merc_familia b ON    
							a.cd_emp = b.cd_emp AND    
							a.cd_tbl_desc_qtde = b.cd_tbl_desc_qtde    
						INNER JOIN est_prod_tbl_desc_qtde_prc_filial fil ON    
							b.cd_emp = fil.cd_emp AND    
							b.cd_tbl_desc_qtde = fil.cd_tbl_desc_qtde    
						INNER JOIN rs_est_prod_arv_merc arv ON    
							b.cd_emp = arv.cd_emp AND    
							b.cd_arv_merc_familia = arv.cd_arv_merc_familia    
						INNER JOIN rs_tab_qtde_ativa atv ON    
							a.cd_emp = atv.cd_emp AND    
							b.cd_tbl_desc_qtde = atv.cd_tbl_desc_qtde        
				WHERE     
					fil.cd_filial = int_cd_filial;
			-------------------------------------------------------------------------------------------------------------------------------        
			--CONSULTANDO AS TBLS DE DESCONTO PARA VERIFICAR SE HA ALGUM DESCONTO NO NIVEL 3 - MARCAS    
			-------------------------------------------------------------------------------------------------------------------------------    
			INSERT INTO temp_rs_tab_desc_leve_page     
				SELECT
						a.cd_tbl_desc_qtde AS cd_tbl_desc_qtde,    
						a.cd_tp_desconto AS tp_desc,    
						(abs(int_qtde / a.qtde_leve) * a.qtde_pague) + (int_qtde - (abs(int_qtde / a.qtde_leve) * a.qtde_leve)) as qtde_pg,          
						3 AS tp_nivel,
						agregacao,
						a.dt_ini    
				FROM est_prod_tbl_desc_qtde a    
						INNER JOIN est_prod_tbl_desc_qtde_est_mc b ON    
							a.cd_emp = b.cd_emp AND    
							a.cd_tbl_desc_qtde = b.cd_tbl_desc_qtde    
						INNER JOIN est_prod_tbl_desc_qtde_prc_filial fil ON    
							b.cd_emp = fil.cd_emp AND    
							b.cd_tbl_desc_qtde = fil.cd_tbl_desc_qtde    
						INNER JOIN rs_est_prod_arv_merc arv ON    
							b.cd_emp = arv.cd_emp AND    
							b.cd_mc = arv.cd_mc    
						INNER JOIN rs_tab_qtde_ativa atv ON    
							a.cd_emp = atv.cd_emp AND    
							b.cd_tbl_desc_qtde = atv.cd_tbl_desc_qtde        
				WHERE     
					fil.cd_filial = int_cd_filial;
			-------------------------------------------------------------------------------------------------------------------------------    
			--CONSULTANDO AS TBLS DE DESCONTO PARA VERIFICAR SE HA ALGUM DESCONTO NO NIVEL 4 - FABRICANTES    
			-------------------------------------------------------------------------------------------------------------------------------    
			INSERT INTO temp_rs_tab_desc_leve_page     
				SELECT   
						a.cd_tbl_desc_qtde AS cd_tbl_desc_qtde,    
						a.cd_tp_desconto AS tp_desc,    
						(abs(int_qtde / a.qtde_leve) * a.qtde_pague) + (int_qtde - (abs(int_qtde / a.qtde_leve) * a.qtde_leve)) as qtde_pg,         
						4 AS tp_nivel,
						agregacao,
						a.dt_ini     
				FROM est_prod_tbl_desc_qtde a    
						INNER JOIN est_prod_tbl_desc_qtde_est_prod_fabric b ON    
							a.cd_emp = b.cd_emp AND    
							a.cd_tbl_desc_qtde = b.cd_tbl_desc_qtde    
						INNER JOIN est_prod_tbl_desc_qtde_prc_filial fil ON    
							b.cd_emp = fil.cd_emp AND    
							b.cd_tbl_desc_qtde = fil.cd_tbl_desc_qtde    
						INNER JOIN rs_est_prod_arv_merc arv ON    
							b.cd_emp = arv.cd_emp AND    
							b.cd_fabric = arv.cd_fabric     
						INNER JOIN rs_tab_qtde_ativa atv ON    
							b.cd_emp = atv.cd_emp AND    
							b.cd_tbl_desc_qtde = atv.cd_tbl_desc_qtde        
				WHERE     
					fil.cd_filial = int_cd_filial;
			------------------------------------------------------------------------------------------------------------------------------    
			--CONSULTANDO AS TBLS DE DESCONTO PARA VERIFICAR SE HA ALGUM DESCONTO NO NIVEL 5 - CATEGORIAS         
			-------------------------------------------------------------------------------------------------------------------------------    
			INSERT INTO temp_rs_tab_desc_leve_page     
				SELECT   
						a.cd_tbl_desc_qtde AS cd_tbl_desc_qtde,    
						a.cd_tp_desconto AS tp_desc,    
						(abs(int_qtde / a.qtde_leve) * a.qtde_pague) + (int_qtde - (abs(int_qtde / a.qtde_leve) * a.qtde_leve)) as qtde_pg,           
						5 AS tp_nivel,
						agregacao,
						a.dt_ini  
				FROM est_prod_tbl_desc_qtde a    
						INNER JOIN est_prod_tbl_desc_qtde_est_arv_merc_categoria b ON    
							a.cd_emp = b.cd_emp AND    
							a.cd_tbl_desc_qtde = b.cd_tbl_desc_qtde    
						INNER JOIN est_prod_tbl_desc_qtde_prc_filial fil ON    
							b.cd_emp = fil.cd_emp AND    
							b.cd_tbl_desc_qtde = fil.cd_tbl_desc_qtde    
						INNER JOIN rs_est_prod_arv_merc arv ON    
							b.cd_emp = arv.cd_emp AND    
							b.cd_arv_merc_categ = arv.cd_arv_merc_categ    
						INNER JOIN rs_tab_qtde_ativa atv ON    
							a.cd_emp = atv.cd_emp AND    
							b.cd_tbl_desc_qtde = atv.cd_tbl_desc_qtde        
				WHERE     
					fil.cd_filial = int_cd_filial;
			-------------------------------------------------------------------------------------------------------------------------------    
			--CONSULTANDO AS TBLS DE DESCONTO PARA VERIFICAR SE HA ALGUM DESCONTO NO NIVEL 6 - LINHAS
			-------------------------------------------------------------------------------------------------------------------------------    
			INSERT INTO temp_rs_tab_desc_leve_page     
				SELECT   
						a.cd_tbl_desc_qtde AS cd_tbl_desc_qtde,    
						a.cd_tp_desconto AS tp_desc,    
						(abs(int_qtde / a.qtde_leve) * a.qtde_pague) + (int_qtde - (abs(int_qtde / a.qtde_leve) * a.qtde_leve)) as qtde_pg,        
						6 AS tp_nivel,
						agregacao,
						a.dt_ini 
				FROM est_prod_tbl_desc_qtde a    
						INNER JOIN est_prod_tbl_desc_qtde_est_arv_merc_linha b ON    
							a.cd_emp = b.cd_emp AND    
							a.cd_tbl_desc_qtde = b.cd_tbl_desc_qtde    
						INNER JOIN est_prod_tbl_desc_qtde_prc_filial fil ON    
							b.cd_emp = fil.cd_emp and    
							b.cd_tbl_desc_qtde = fil.cd_tbl_desc_qtde    
						INNER JOIN rs_est_prod_arv_merc arv ON    
							b.cd_emp = arv.cd_emp AND       
							b.cd_arv_merc_linha = arv.cd_arv_merc_linha    
						INNER JOIN rs_tab_qtde_ativa atv ON    
							a.cd_emp = atv.cd_emp AND    
							b.cd_tbl_desc_qtde = atv.cd_tbl_desc_qtde        
				WHERE     
					fil.cd_filial = int_cd_filial;
		END IF;
	END IF;
	-------------------------------------------------------------------------------------------------------------------------------
	-- RETORNANDO DESCONTO LIMITE (RESULTADO DA FUNCAO)
	-------------------------------------------------------------------------------------------------------------------------------
	FOR returnRec IN 
		SELECT cd_tbl_desc_qtde, tp_desc, qtde_pag, 1, round((1-(CAST(qtde_pag AS numeric)/int_qtde))*100,2), round((1-(CAST(qtde_pag AS numeric)/int_qtde))*100,2), tp_nivel, agregacao 
		  FROM temp_rs_tab_desc_leve_page 
		 ORDER BY tp_nivel ASC, qtde_pag DESC, dt_ini DESC LIMIT 1
	LOOP
		RETURN NEXT returnRec;
	END LOOP;
END; --FIM DOS BLOCOS DA FUNÇÃO

$BODY$;

ALTER FUNCTION public.ufd_est_prod_tbl_desc_leve_pague(integer, integer, integer, integer, integer)
    OWNER TO postgres;

